import { StarXpandCommand } from "star-io10-web";

export class LabelSample12_For203dpiAnd300dpi_InventoryLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleUnderLine(true)
                .actionPrintText("${name}\n"),
            )
            .actionPrintText("P/N: ${parts_number%06u}\n")
            .actionPrintBarcode(
              new StarXpandCommand.Printer.BarcodeParameter(
                "${sku}",
                StarXpandCommand.Printer.BarcodeSymbology.Code39,
              )
                .setBarDots(3)
                .setHeight(18.0)
                .setPrintHri(true),
            )
            .actionPrintText("\n" + "ABC: ${abc}\n")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "name" : "Star TSP100IV",
    "parts_number" : 1,
    "sku" : "2558271100",
    "abc" : "WAREHOUSE"
}`,
    );
  }
}
